#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef pair<int, int> Point;
#define x first
#define y second

const int OFFSET = 1 << 18;

int n, q;
Point pts[OFFSET];

struct Stats {
  int l, r;
  ll sum;
};

Stats tree[2 * OFFSET];

ll Area(int a, int b, int c) {
  ll w = (ll)pts[a].x * (pts[b].y - pts[c].y);
  w += (ll)pts[b].x * (pts[c].y - pts[a].y);
  w += (ll)pts[c].x * (pts[a].y - pts[b].y);
  return abs(w);
}

Stats Merge(Stats a, Stats b) {
  if (a.l == -1) return b;
  if (b.l == -1) return a;
  ll sum = a.sum + b.sum + Area(a.l, a.r, b.l) + Area(a.l, b.l, b.r);
  return {a.l, b.r, sum};
}

void Update(int pos, ll val) {
  tree[pos + OFFSET] = {pos, pos, val};
  for (pos = (pos + OFFSET) / 2; pos > 0; pos /= 2) {
    tree[pos] = Merge(tree[2 * pos], tree[2 * pos + 1]);
  }
}

Stats Query(int from, int to, int node = 1, int lo = 0, int hi = OFFSET) {
  if (lo >= from && hi <= to) return tree[node];
  if (lo >= to || hi <= from) return {-1, -1, -1};
  int mid = (lo + hi) / 2;
  return Merge(Query(from, to, 2 * node, lo, mid),
               Query(from, to, 2 * node + 1, mid, hi));
}

set<int> active;

int Next(int p) {
  auto it = active.find(p);
  assert(it != active.end());
  it++;
  if (it == active.end()) return *active.begin();
  return *it;
}

int Prev(int p) {
  auto it = active.find(p);
  assert(it != active.end());
  if (it == active.begin()) return *active.rbegin();
  it--;
  return *it;
}

int main(void) {
  cin >> n;
  for (int i = 0; i < n; ++i) {
    cin >> pts[i].x >> pts[i].y;
    active.insert(i);
  }

  for (int i = 0; i < n; ++i) {
    Update(i, 0);
  }
  
  ll total_area = Query(0, n).sum;

  cin >> q;
  for (int i = 0; i < q; ++i) {
    int cmd;
    cin >> cmd;
    if (cmd == 1) {
      int l, r;
      cin >> l >> r;
      if (l > r) swap(l, r);
      ll area1 = Query(l - 1, r).sum;
      ll area2 = total_area - area1;
      ll diff = abs(area1 - area2);
      cout << diff / 2 << (diff % 2 == 0 ? "" : ".5") << endl;
    } else {
      int pos;
      cin >> pos;
      pos--;
      int ppos = Prev(pos);
      int npos = Next(pos);
      ll area = Area(ppos, pos, npos);
      total_area -= area;
      Update(pos, -area);
      active.erase(pos);
    }
  }
  return 0;
}
